//Listing 9 My first Add-In
//C++
#include <cppuhelper/implbase5.hxx> // "5" implementing five interfaces
#include <cppuhelper/factory.hxx>
#include <cppuhelper/implementationentry.hxx>
 
#include <com/sun/star/lang/XServiceInfo.hpp>
#include <com/sun/star/lang/XInitialization.hpp>
#include <com/sun/star/lang/XServiceName.hpp>
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#include <com/sun/star/sheet/XAddIn.hpp>
#include <com/sun/star/lang/XLocalizable.hpp>
#include <my_module/XSomething.hpp>
 
 
using namespace ::rtl; // for OUString
using namespace ::com::sun::star; // for odk interfaces
using namespace ::com::sun::star::uno; // for basic types
using namespace ::com::sun::star::sheet;
 
 
namespace my_sc_impl
{
 
static Sequence< OUString > getSupportedServiceNames_MyService2Impl()
{
	static Sequence < OUString > *pNames = 0;
	if( ! pNames )
	{
//		MutexGuard guard( Mutex::getGlobalMutex() );
		if( !pNames )
		{
			static Sequence< OUString > seqNames(2);
			seqNames.getArray()[0] = OUString(RTL_CONSTASCII_USTRINGPARAM("my_module.MyService2"));
                        seqNames.getArray()[1] = OUString(RTL_CONSTASCII_USTRINGPARAM("com.sun.star.sheet.AddIn"));
			pNames = &seqNames;
		}
	}
	return *pNames;
}
 
static OUString getImplementationName_MyService2Impl()
{
	static OUString *pImplName = 0;
	if( ! pImplName )
	{
//		MutexGuard guard( Mutex::getGlobalMutex() );
		if( ! pImplName )
		{
			static OUString implName( RTL_CONSTASCII_USTRINGPARAM("my_module.my_sc_implementation.MyService2") );
			pImplName = &implName;
		}
	}
	return *pImplName;
}
 
class MyService2Impl : public ::cppu::WeakImplHelper5<
      ::my_module::XSomething, lang::XServiceInfo, lang::XInitialization, lang::XServiceName,
	/*lang::XLocalizable, */XAddIn>
{
    OUString m_arg;
public:
    // focus on three given interfaces,
    // no need to implement XInterface, XTypeProvider, XWeak
 
    // XInitialization will be called upon createInstanceWithArguments[AndContext]()
    virtual void SAL_CALL initialize( Sequence< Any > const & args )
        throw (Exception);
    // XSomething
    virtual OUString SAL_CALL methodOne( OUString const & str )
        throw (RuntimeException);
    // **********************ADDED
    virtual OUString SAL_CALL methodTwo( OUString const & str )
        throw (RuntimeException);
    virtual sal_Int32 SAL_CALL methodThree(const Sequence< Sequence< sal_Int32 > > &aValList )
        throw (RuntimeException);
    virtual Sequence< Sequence< sal_Int32 > > SAL_CALL methodFour(
				const Sequence< Sequence< sal_Int32 > > &aValList )
	throw (RuntimeException);
    // ********************** END ADDED
    // XServiceName
    virtual OUString SAL_CALL getServiceName() throw( uno::RuntimeException );
    // XServiceInfo
    virtual OUString SAL_CALL getImplementationName()
        throw (RuntimeException);
    virtual sal_Bool SAL_CALL supportsService( OUString const & serviceName )
        throw (RuntimeException);
    virtual Sequence< OUString > SAL_CALL getSupportedServiceNames()
        throw (RuntimeException);
    // XAddIn
    virtual OUString SAL_CALL getProgrammaticFuntionName( const OUString& aDisplayName ) throw( uno::RuntimeException );
    virtual OUString SAL_CALL getDisplayFunctionName( const OUString& aProgrammaticName ) throw( uno::RuntimeException );
    virtual OUString SAL_CALL getFunctionDescription( const OUString& aProgrammaticName ) throw( uno::RuntimeException );
    virtual OUString SAL_CALL getDisplayArgumentName(
        const OUString& aProgrammaticName, sal_Int32 nArgument ) throw( uno::RuntimeException );
    virtual OUString SAL_CALL getArgumentDescription(
        const OUString& aProgrammaticName, sal_Int32 nArgument ) throw( uno::RuntimeException );
    virtual OUString SAL_CALL getProgrammaticCategoryName(
        const OUString& aProgrammaticName ) throw( uno::RuntimeException );
    virtual OUString SAL_CALL getDisplayCategoryName(
        const OUString& aProgrammaticName ) throw( uno::RuntimeException );
    // XLocalizable
    virtual void SAL_CALL setLocale( const lang::Locale& eLocale ) throw( uno::RuntimeException );
    virtual lang::Locale SAL_CALL getLocale() throw( uno::RuntimeException );
};
 
// XInitialization implemention
void MyService2Impl::initialize( Sequence< Any > const & args )
    throw (Exception)
{
    if (1 != args.getLength())
    {
        throw lang::IllegalArgumentException(
            OUString( RTL_CONSTASCII_USTRINGPARAM("give a string instanciating this component!") ),
            (::cppu::OWeakObject *)this, // resolve to XInterface reference
            0 ); // argument pos
    }
    if (! (args[ 0 ] >>= m_arg))
    {
        throw lang::IllegalArgumentException(
            OUString( RTL_CONSTASCII_USTRINGPARAM("no string given as argument!") ),
            (::cppu::OWeakObject *)this, // resolve to XInterface reference
            0 ); // argument pos
    }
}
 
// XServiceName
OUString SAL_CALL MyService2Impl::getServiceName() throw( uno::RuntimeException )
{
    // name of specific AddIn service
    return OUString::createFromAscii( "my_module.MyService2" );
}
// XSomething implementation
OUString MyService2Impl::methodOne( OUString const & str )
    throw (RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM(
        "called methodOne() of MyService2 implementation: ") ) + m_arg + str;
}
// **********************ADDED 
 
OUString MyService2Impl::methodTwo( OUString const & str )
    throw (RuntimeException)
{
    return OUString( RTL_CONSTASCII_USTRINGPARAM(
        "called methodTwo() of MyService2 implementation: ") ) + m_arg + str;
}
 
 
sal_Int32 MyService2Impl::methodThree(const Sequence< Sequence< sal_Int32 > > &aValList )
    throw (RuntimeException)
{ 	sal_Int32		n1, n2;
	sal_Int32		nE1 = aValList.getLength();
	sal_Int32		nE2;
	sal_Int32 temp=0;
	for( n1 = 0 ; n1 < nE1 ; n1++ )
	{
		const Sequence< sal_Int32 >	rList = aValList[ n1 ];
		nE2 = rList.getLength();
		const sal_Int32*	pList = rList.getConstArray();
		for( n2 = 0 ; n2 < nE2 ; n2++ )
		{
			temp += pList[ n2 ];
		}
	}
	return temp;
}
 
//It's a matrix operation  should be called like : {=METHODFOUR(A1:B4)}
Sequence< Sequence< sal_Int32 > > MyService2Impl::methodFour(
		const Sequence< Sequence< sal_Int32 > > &aValList )throw (RuntimeException)
{ 	sal_Int32		n1, n2;
	sal_Int32		nE1 = aValList.getLength();
	sal_Int32		nE2;
	Sequence< Sequence< sal_Int32 > > temp = aValList;
	for( n1 = 0 ; n1 < nE1 ; n1++ )
	{
		Sequence< sal_Int32 >	rList = temp[ n1 ];
		nE2 = rList.getLength();
		for( n2 = 0 ; n2 < nE2 ; n2++ )
		{
			rList[ n2 ] += 4;
		}
		temp[n1]=rList;
	}
	return temp;
}
 
// ********************** END ADDED 
 
// XAddIn
 
OUString SAL_CALL MyService2Impl::getProgrammaticFuntionName( const OUString& aDisplayName ) throw( uno::RuntimeException )
{
    //  not used by calc
    //  (but should be implemented for other uses of the AddIn service)
    return OUString();
}
 
OUString SAL_CALL MyService2Impl::getDisplayFunctionName( const OUString& aProgrammaticName ) throw( uno::RuntimeException )
{
    OUString aProgName, aRet;
    aProgName = aProgrammaticName;
    if (aProgName.equalsAscii("methodOne")) aRet = OUString::createFromAscii("method1");
    if (aProgName.equalsAscii("methodTwo")) aRet = OUString::createFromAscii("method2");
    if (aProgName.equalsAscii("methodThree")) aRet = OUString::createFromAscii("method3");
    if (aProgName.equalsAscii("methodFour")) aRet = OUString::createFromAscii("method4");
 
    return aRet;
}
 
OUString SAL_CALL MyService2Impl::getFunctionDescription( const OUString& aProgrammaticName ) throw( uno::RuntimeException )
{
    OUString aRet;
    if (aProgrammaticName.equalsAscii("methodOne")) 
	aRet = OUString::createFromAscii("methodOne() : 1st try");
    if (aProgrammaticName.equalsAscii("methodTwo")) 
	aRet = OUString::createFromAscii("methodTwo() : 1st try");
    if (aProgrammaticName.equalsAscii("methodThree")) 
	aRet = OUString::createFromAscii("methodThree() : 1st try");
    return aRet;
}
 
OUString SAL_CALL MyService2Impl::getDisplayArgumentName(
        const OUString& aProgrammaticName, sal_Int32 nArgument ) throw( uno::RuntimeException )
{   
    OUString aRet;
    if (aProgrammaticName.equalsAscii("methodOne")||aProgrammaticName.equalsAscii("methodTwo")) 
	aRet = OUString::createFromAscii("a string");
    if (aProgrammaticName.equalsAscii("methodThree")||aProgrammaticName.equalsAscii("methodFour")) 
	aRet = OUString::createFromAscii("a Cell Range");
    return aRet;
}
 
OUString SAL_CALL MyService2Impl::getArgumentDescription(
        const OUString& aProgrammaticName, sal_Int32 nArgument ) throw( uno::RuntimeException )
{
    OUString aRet;
    if (aProgrammaticName.equalsAscii("methodOne")||aProgrammaticName.equalsAscii("methodTwo")) 
	aRet = OUString::createFromAscii("method1/2:a string or a cell with a string is required");
    if (aProgrammaticName.equalsAscii("methodThree")||aProgrammaticName.equalsAscii("methodFour")) 
	aRet = OUString::createFromAscii("method3/4:a cell range is required");
    return aRet;
}
 
OUString SAL_CALL MyService2Impl::getProgrammaticCategoryName(
        const OUString& aProgrammaticName ) throw( uno::RuntimeException )
{
    OUString aRet( RTL_CONSTASCII_USTRINGPARAM("Add-In"));
    return aRet;
}
 
OUString SAL_CALL MyService2Impl::getDisplayCategoryName(
        const OUString& aProgrammaticName ) throw( uno::RuntimeException )
{
    return getProgrammaticCategoryName( aProgrammaticName );
}
 
// XServiceInfo implementation
OUString MyService2Impl::getImplementationName()
    throw (RuntimeException)
{
    // unique implementation name
    return OUString( RTL_CONSTASCII_USTRINGPARAM("my_module.my_sc_impl.MyService2") );
}
sal_Bool MyService2Impl::supportsService( OUString const & serviceName )
    throw (RuntimeException)
{
    // this object only supports one service, so the test is simple
    // modified *********
    return serviceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM("my_module.MyService2") ) ||
           serviceName.equalsAsciiL( RTL_CONSTASCII_STRINGPARAM("com.sun.star.sheet.AddIn") );
}
Sequence< OUString > MyService2Impl::getSupportedServiceNames()
    throw (RuntimeException)
{
	return getSupportedServiceNames_MyService2Impl();
}
 
Reference< XInterface > SAL_CALL create_MyService2Impl(
    Reference< XComponentContext > const & xContext )
    SAL_THROW( () )
{
    return static_cast< lang::XTypeProvider * >( new MyService2Impl() );
}
 
// XLocalizable
void SAL_CALL MyService2Impl::setLocale( const lang::Locale& eLocale ) throw( uno::RuntimeException )
{
//    aFuncLoc = eLocale;
//    InitData();     // change of locale invalidates resources!
}
 
lang::Locale SAL_CALL MyService2Impl::getLocale() throw( uno::RuntimeException )
{
//    return aFuncLoc;
}
 
 
}
 
/* shared lib exports implemented without helpers in service_impl1.cxx */
namespace my_sc_impl
{
static struct ::cppu::ImplementationEntry s_component_entries [] =
{
    {
        create_MyService2Impl, getImplementationName_MyService2Impl,
        getSupportedServiceNames_MyService2Impl, ::cppu::createSingleComponentFactory,
        0, 0
    },
    { 0, 0, 0, 0, 0, 0 }
};
}
 
extern "C"
{
void SAL_CALL component_getImplementationEnvironment(
    sal_Char const ** ppEnvTypeName, uno_Environment ** ppEnv )
{
    *ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}
sal_Bool SAL_CALL component_writeInfo(
    lang::XMultiServiceFactory * xMgr, registry::XRegistryKey * xRegistry )
{
    return ::cppu::component_writeInfoHelper(
        xMgr, xRegistry, ::my_sc_impl::s_component_entries );
}
void * SAL_CALL component_getFactory(
    sal_Char const * implName, lang::XMultiServiceFactory * xMgr,
    registry::XRegistryKey * xRegistry )
{
    return ::cppu::component_getFactoryHelper(
        implName, xMgr, xRegistry, ::my_sc_impl::s_component_entries );
}
}


