/*
   This file is part of LPIC++, a particle-in-cell code for
   simulating the interaction of laser light with plasma.

   Copyright (C) 1994-1997 Roland Lichters

   LPIC++ is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef ERROR_H
#define ERROR_H

#include <common.h>

#include <string>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>

using namespace std;

class error_handler {
    static int error_number;
    static int message_number;
    static int Q_debug;
    static int debug_number;
    static int object_number;
    std::string    my_name;
    std::string    errname;
    std::ofstream  errfile;
    static int tab;
public:
    error_handler(std::string, std::string error_file_name);
    void error(std::string s1,    std::string  s2="",
	       std::string s3="", std::string  s4="");
    void error(std::string s1,    double d2,
	       std::string s3="", std::string  s4="");

    void message(std::string m1,
		 std::string m2="", std::string  m3="", std::string m4="");
    void message(std::string m1,    double m2,
		 std::string m3="", std::string  m4="");
    void message(std::string m1,    double m2,    std::string m3, double m4);
    void message(std::string m1,    double m2,    std::string m3, double m4,
		 std::string m5,    double m6,    std::string m7, double m8);
    void message(std::string m1, double m2, double m3, double m4, double m5 );
    void message(std::string m1, double m2, double m3, double m4 );
    void message(std::string m1, double m2, std::string m3,  double m4, std::string m5, double m6);
    void message(std::string s1, double d2, double d3);
    void message(std::string s1, std::string s2, double d3);

    void debug(std::string m1,
	       std::string m2="", std::string  m3="", std::string m4="");
    void debug(std::string m1,    double m2,
	       std::string m3="", std::string  m4="");
    void debug(std::string m1   , double m2,    std::string m3, double m4);
    void debug(std::string m1   , double m2,    std::string m3, double m4, std::string m5, double m6);
};


std::string toString(int i);
std::string toString(double d, int precision);

#endif







