(defvar mtm-license
"
   This file is part of MTM, an experimental program for tutorials in
   financial modelling - mtm@lichters.net

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
")

; skeleton for a new header file---you might want to bind this to some key
(defun mtm-new-header ()
  (interactive)
  (mtm-add-license)
  (mtm-add-file-description)
  (insert "\n")
  (mtm-add-include-guard)
  (mtm-add-sample-header)
  (insert "\n")
  (mtm-add-namespace))

; skeleton for a new source file---you might want to bind this to some key
(defun mtm-new-source ()
  (interactive)
  (mtm-add-license)
  (insert "\n")
  (mtm-add-sample-header)
  (insert "\n")
  (mtm-add-namespace))

(require 'cc-mode)
(defvar c++-font-lock-extra-types)

; A few types for syntax-highlighting
; from QuantLib:
(setq c++-font-lock-extra-types
      (append c++-font-lock-extra-types
              '("QuantLib"
                "Integer" "BigInteger" "Natural" "BigNatural" "Real" "Decimal"
                "Time" "Rate" "Spread" "DiscountFactor" "Size" "Volatility"
                "Date" "Day" "Month" "Year" "Weekday"
                "TimeUnit" "Frequency" "Compounding" "Period" "DayCounter"
                "Calendar" "BusinessDayConvention"
                "Currency" "ExchangeRate" "Money" "Rounding"
                "InterestRate"
                "History"
                "Handle")))
; from Boost:
(setq c++-font-lock-extra-types
      (append c++-font-lock-extra-types
              '("Boost"
                "shared_ptr" "format")))


; helper functions

(defun mtm-add-license ()
  (let ((holder (read-from-minibuffer "Copyright holder? ")))
    (let ((copyright-notice
           (apply 'string (append "   Copyright (C) "
                                  (substring (current-time-string) -4)
                                  " "
                                  holder
                                  "\n"
                                  ()))))
      (insert "\n/*\n"
              copyright-notice
              mtm-license
              "*/\n\n"))))

(defun mtm-add-file-description ()
  (let ((filename (buffer-name))
        (description (read-from-minibuffer "Short file description? ")))
    (insert "/*! \\file " filename "\n"
            "    \\brief " description "\n"
            "*/\n")))

(defun mtm-add-include-guard ()
  (let ((guard (read-from-minibuffer "Include guard? ")))
    (insert "#ifndef " guard "\n"
            "#define " guard "\n"
            "\n\n\n"
            "#endif\n"))
  (previous-line 3))

(defun mtm-add-sample-header ()
  (insert "#include <mtm.h>\n"))


(defun mtm-add-namespace ()
  (insert "namespace MTM {\n"
          "\n\n\n"
          "}\n")
  (previous-line 3)
  (c-indent-command))

