
/*
   Copyright (C) 2005 Roland Lichters

   This file is part of MTM, an experimental program for tutorials in
   financial modelling - mtm@lichters.net

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef MAPPING_H
#define MAPPING_H

#include <ql/quantlib.hpp>
#include "debug.h"

#define LENGTH(a) (sizeof(a)/sizeof(a[0]))

using namespace QuantLib;

namespace QL = QuantLib;

bool              isBlank   ( const char *text );
bool              isBlank   ( std::string text );
Date              parseDate ( const char *text, Date asof = Date::minDate() );
Date              parseDate ( std::string text, Date asof = Date::minDate() );
Date              mapDate   ( const char *text, Date asof = Date::minDate() );
Date              mapDate   ( std::string text, Date asof = Date::minDate() );
Calendar          mapCalendar         ( const char *text );
Calendar          mapCalendar         ( std::string text );
DayCounter        mapDayCounter       ( const char *text );
DayCounter        mapDayCounter       ( std::string text );
BusinessDayConvention mapRollingConvention( const char *text );
BusinessDayConvention mapRollingConvention( std::string text );
Frequency         mapFrequency        ( const char *text );
Frequency         mapFrequency        ( std::string text );
bool              mapYorN             ( const char *text );
bool              mapYorN             ( std::string text );
boost::shared_ptr<Xibor> mapIndex (const char *ccy, const char *name,
                                   const char *term,
                                   Handle<YieldTermStructure> rhTermStructure);
boost::shared_ptr<Xibor> mapIndex (std::string ccy, std::string name,
                                   std::string term,
                                   Handle<YieldTermStructure> rhTermStructure);

#endif
