/*
   This file stems from SXP, a C++ library for object serialization in XML,
   written by Ivan-Assen Ivanov, sxp.sourceforge.net

   Enclosed is the "Disclaimer and License" section from this site:

   SXP has not been extensively tested. It worked on all the test examples I wrote,
   a modification of it works inside a commercial application I'm working on, but I
   can't guarantee it will work for you. If it crashes your system, deletes or corrupts
   your data, and destroys your personal life, it's not my fault - you've been warned.
   Proceed at your own risk.

   SXP can be distributed by any of the non-viral public licenses out there. I like the
   Artistic License; I don't like the GPL. Basically, do whatever you like with it, let
   me know if you make it better, and don't put it under the GPL. If you badly need it
   under the GPL (evil! evil!), please contact me and we'll arrange something (e.g. an
   exception just for your project).
*/

/*
   Changes by Roland Lichters 2005-07-12:
   - added static variable DEBUG and some trace messages
   - definition of struct Tag moved upwards to the declaration, since this is needed
     in sxp_data.h when compiled using gcc 4 on Mac OS X 10.4
   - wstring related functions WriteElement, Retrieve, XMLEscapeW commented out
   - Indent() changed to use 2 blanks instead of one tab
   - virtual destructors added to IParser and IPersistObj to get rid of compiler warnings
   - added IFilePointer<T>:: to Indent() and FP() calls in sxp_data.h to resove scope
     error messages from gcc 4
*/

// this file is included by sxp.h
// here "cleanly" separated is the functionality for converting
// between char * data and simple data types
// adding methods to these two interfaces automagically adds them respectively
// to the IElement and IOutStream interfaces passed to your user classes

// IDataOutput: bundles together methods for printing out simple data
// to a tag, e.g. <height>188</height> to the
// stdio.h file pointer returned by the FP() method, aided by an Indent()
// method which knows how many tabs to print before your tag.

template<class T>
interface IDataOutput :
IFilePointer<T>
{
  // add more simple type writers here

  inline void WriteElement(Tag& t, int val) {
    IFilePointer<T>::Indent();
    fprintf(IFilePointer<T>::FP(), "<%s>%d</%s>\n", t.ch, val, t.ch);
  }

  inline void WriteElement(Tag& t, double val) {
    IFilePointer<T>::Indent();
    fprintf(IFilePointer<T>::FP(), "<%s>%g</%s>\n", t.ch, val, t.ch);
  }

  inline void WriteElement(Tag& t, std::string val) {
    IFilePointer<T>::Indent();
    if( !val.empty() )
      fprintf(IFilePointer<T>::FP(), "<%s>%s</%s>\n",
        t.ch, XMLEscape(val.c_str()).c_str(), t.ch);
    else
      fprintf(IFilePointer<T>::FP(), "<%s/>\n", t.ch);
  }
  // RL 2005-07-12: I had to comment out this section to make the code compile
  //                under Mac OS X Panther and Tiger
  /*
    inline void WriteElement(Tag& t, wstring val) {
    Indent();
    if( !val.empty() )
    fprintf(FP(), "<%s>%s</%s>\n", t.ch, XMLEscapeW(val.c_str()).c_str(), t.ch);
    else
    fprintf(FP(), "<%s/>\n", t.ch);
    }
  */
};

// IDataInput: bundles together methods for converting from the char*
// returned by the Data() method (inherited from IData).

interface IDataInput: public IData
{
  inline void Retrieve(int& val) {
    val = atol(Data());
    // RL 2005-07-12
    if (SXP::debug) { printf( "... retrieved int %d\n", val ); }
  }

  inline void Retrieve(double& val) {
    val = atof(Data());
    // RL 2005-07-12
    if (SXP::debug) { printf( "... retrieved double %.6f\n", val ); }
  }

  inline void Retrieve(string& val) {
    val = XMLUnEscape(Data());
    // RL 2005-07-12
    if (SXP::debug) { printf( "... retrieved string %s\n", val.c_str() ); }
  }

  // RL 2005-07-12: I had to comment out this section to make the code compile
  //                under Mac OS X Panther and Tiger
  /*
    inline void Retrieve(wstring& val) {
    val = XMLUnEscapeW(Data());
    if (SXP::debug) { printf( "... retrieved wstring\n" ); }
    }
  */
};
