# RL_TO_UPPER(STRING)
# -------------------
# Convert the passed string to uppercase
AC_DEFUN([RL_TO_UPPER],
[translit([$1],[abcdefghijklmnopqrstuvwxyz.],[ABCDEFGHIJKLMNOPQRSTUVWXYZ_])])

# RL_CHECK_HEADER(HEADER)
# -----------------------
# Check whether <cheader> exists, falling back to <header.h>.
# It defines HAVE_CHEADER or HAVE_HEADER_H and sets the rl_header
# variable depending on the one found.
AC_DEFUN([RL_CHECK_HEADER],
[AC_CHECK_HEADER(
    [c$1],
    [AC_SUBST([rl_$1],[c$1])
     AC_DEFINE(RL_TO_UPPER([have_c$1]),[1],
               [Define to 1 if you have the <c$1> header file.])
    ],
    [AC_CHECK_HEADER([$1.h],
        [AC_SUBST([ql_$1],[$1.h])
         AC_DEFINE(RL_TO_UPPER(have_$1_h),1,
                   [Define to 1 if you have the <$1.h> header file.])
        ],
        [AC_MSG_ERROR([$1 not found])])
    ])
])

# RL_CHECK_FUNC(FUNCTION,ARGS,HEADER)
# -----------------------------------
# Check whether FUNCTION (including namespace qualifier) when compiling
# after including HEADER. 
AC_DEFUN([RL_CHECK_FUNC],
[AC_MSG_CHECKING([for compilation with $1])
 AC_TRY_COMPILE(
    [@%:@include <$3>],
    [$1($2);],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([$1 did not compile])])
])

# RL_CHECK_NAMESPACES
# ----------------------------------------------
# Check whether namespaces are supported.
AC_DEFUN([RL_CHECK_NAMESPACES],
[AC_MSG_CHECKING([namespace support])
 AC_TRY_COMPILE(
    [namespace Foo { struct A {}; }
     using namespace Foo;
    ],
    [A a;],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([namespaces not supported])
    ])
])

# RL_CHECK_EXPAT_HEADER
# ---------------------
# Check whether the Boost headers are available
AC_DEFUN([RL_CHECK_EXPAT],
[AC_MSG_CHECKING([for Expat header])
 AC_TRY_COMPILE(
    [@%:@include <expat.h>],
    [],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([Expat header not found])
    ])
])

# RL_CHECK_BOOST_DEVEL
# --------------------
# Check whether the Boost headers are available
AC_DEFUN([RL_CHECK_BOOST_DEVEL],
[AC_MSG_CHECKING([for Boost development files])
 AC_TRY_COMPILE(
    [@%:@include <boost/version.hpp>
     @%:@include <boost/shared_ptr.hpp>
     @%:@include <boost/assert.hpp>
     @%:@include <boost/current_function.hpp>],
    [],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([Boost development files not found])
    ])
])

# RL_CHECK_BOOST_VERSION
# ----------------------
# Check whether the Boost installation is up to date
AC_DEFUN([RL_CHECK_BOOST_VERSION],
[AC_MSG_CHECKING([Boost version])
 AC_REQUIRE([RL_CHECK_BOOST_DEVEL])
 AC_TRY_COMPILE(
    [@%:@include <boost/version.hpp>],
    [@%:@if BOOST_VERSION < 103100
     @%:@error too old
     @%:@endif],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([outdated Boost installation])
    ])
])

# RL_CHECK_BOOST
# --------------
# Boost-related tests
AC_DEFUN([RL_CHECK_BOOST],
[AC_REQUIRE([RL_CHECK_BOOST_DEVEL])
 AC_REQUIRE([RL_CHECK_BOOST_VERSION])
])

# RL_CHECK_QUANTLIB
# -----------------
# Check whether the QuantLib headers are available
AC_DEFUN([RL_CHECK_QUANTLIB_HEADER],
[AC_MSG_CHECKING([for QuantLib header files])
 AC_TRY_COMPILE(
    [@%:@include <ql/quantlib.hpp>],
    [],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([QuantLib header files not found])
    ])
])

# RL_CHECK_QUANTLIB_VERSION
# -------------------------
# Check whether the QuantLib installation is up to date
AC_DEFUN([RL_CHECK_QUANTLIB_VERSION],
[AC_MSG_CHECKING([QuantLib version])
 AC_REQUIRE([RL_CHECK_QUANTLIB_HEADER])
 AC_TRY_COMPILE(
    [@%:@include <ql/qldefines.hpp>],
    [@%:@if QL_HEX_VERSION < 0x000310f0
     @%:@error too old
     @%:@endif],
    [AC_MSG_RESULT([yes])],
    [AC_MSG_RESULT([no])
     AC_MSG_ERROR([QuantLib outdated])
    ])
])

# RL_CHECK_QUANTLIB
# -----------------
# QuantLib-related tests
AC_DEFUN([RL_CHECK_QUANTLIB],
[AC_REQUIRE([RL_CHECK_QUANTLIB_HEADER])
 AC_REQUIRE([RL_CHECK_QUANTLIB_VERSION])
])
