
/* WARANTY NOTICE AND COPYRIGHT
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Copyright (C) Michael J. Meyer

matmjm@mindspring.com
spyqqqdia@yahoo.com

*/




#include <examples/TestFormulas.h>
#include <examples/TestOptimizers.h>
#include <examples/TestProbability.h>
#include <examples/Examples.h>
#include <examples/TestMatrix.h>
#include <martingale/VolatilityAndCorrelation.h>
#include <examples/ExercisePlot.h>                 // needs GNU PlotUtils
#include <examples/TestLMM.h>
#include <martingale/LiborCalibrator.h>
#include <martingale/DirichletProblem.h>
#include <martingale/LiborMarketModel.h>
 
using namespace Martingale;



/** Various examples and tests.
 */
int main()
{


	
/*******************************************************************************
 *
 *                        OPTIMIZATION
 *
*******************************************************************************/
#include <examples/TestOptimizers.h>

  /*	
    testDownhillSimplex(5,500);
    testBFGS(5,500);
    testSobolSearch(5,500);
	
    return 0;
  */
	
/*******************************************************************************
 *
 *                        RANDOM NUMBERS, VARIABLES, VECTORS
 *
*******************************************************************************/
#include <examples/TestProbability.h>

  /*	
    testSTNCovarianceMatrix(600,10000);
    testPathFunctional(9,15,30000);

    return 0;
  */

	
/*******************************************************************************
 *
 *                       MATRICES
 *
*******************************************************************************/
#include <examples/TestMatrix.h>
#include <examples/Examples.h>

  /*    
	testMatrixInverse();
	Examples::timeMatrixMultiply(500,1);        
	testMatrixMultiply();
	testMatrixExponentials();
	testSymmetricMatrixExponentials();
	testComplexExponential();
	
	return 0;
  */

	
/*******************************************************************************
 *
 *                       VOLATILITY AND CORRELATION
 *
*******************************************************************************/
#include <martingale/VolatilityAndCorrelation.h>


  //  testVolSurfaceIntegrals(400000,0.5);


	

	
/*******************************************************************************
 *
 *                        LIBOR PROCESS, LMM
 *
*******************************************************************************/
// include <examples/TestLMM.h>
// include <examples/Examples.h>	
	
	
	
// Test_LMM::testLiborFactorLoading(20);
// Test_LMM::testLiborFactorLoadingFactorization(60,3);    // rank 3 factorization
// Test_LMM::testLmmPaths(20);

// Examples::liborPathTiming(50,4000);         // 20000 paths in dimension 50
	

	
// PRICING: all types of LMM:
/*
  int lmmType=LiborMarketModel::FPC;  // DL, LFDL, PC, FPC
  int volType=VolSurface::M;          // JR, M, CONST
  int corrType=Correlations::JR;      // JR, CS

  Test_LMM::testCapletPrice(lmmType,volType,corrType); 
  Test_LMM::testSwaptionPrice(lmmType,volType,corrType);
  Test_LMM::testCallOnBondPrice(lmmType,volType,corrType);
  Test_LMM::testCallOnZeroCouponBondPrice(lmmType,volType,corrType);
*/
// PRICING: drifltess LMM only, includes lattice pricing:

//  Test_LMM::testLiborDerivative();
	
//  return 0;

	
	
	
/*******************************************************************************
 *
 *                        LIBOR CALIBRATION
 *
*******************************************************************************/
// include <martingale/LiborCalibrator.h> 
// include <martingale/VolatilityAndCorrelation.h> 
// include <martingale/LiborMarketModel.h>  

  

	
// SYNTHETIC DATA: write the synthetic data in the directory SyntheticData

// StandardLmmCalibrator::writeSyntheticDataSample();



// CALIBRATION to caplets (exact) and coterminal swaptions (approximate)
// needs the files Capletsin.txt, SwaptionsIn.txt containing the synthetic caplet and swaption prices

/*
	int nVals=500,                            // number of evaluations of the objective function
	    n=50,                                 // 20,30,40,50 dimension in which we calibrate
	    dataLmmType=LiborMarketModel::PC,     // type of LMM the data came from: DL,PC
	    dataVolType=VolSurface::M,            // type of VolSurface used in the generation of data: CONST,JR,M
	    dataCorrType=Correlations::JR,        // type of correlations used in the generation of data: JR,CS
	    lmmType=LiborMarketModel::DL,         // type of LMM which will be calibrated: PC,DL
	    volType=VolSurface::JR,               // type of VolSurface which will be calibrated: CONST,JR,M
	    corrType=Correlations::CS;            // type of correlations which will be calibrated: JR,CS
		
     StandardLmmCalibrator::testCalibration
     (nVals,n,dataLmmType,dataVolType,dataCorrType,lmmType,volType,corrType);
*/
	


	
/*******************************************************************************
 *
 *                        LMM LATTICES
 *
*******************************************************************************/
#include <examples/TestLMM.h>
	
  /*
    Test_LMM::testLmmLattice();

    return 0;
  */

// Exercise boundary plot for Bermudan swaptions (Jaeckel coordinates)
// This needs GNU plotutils, you have to link with libplotter and a variety of supporting libraries
// for details see the plotutils documentation. Once this is installed add the libraries to 
// LD_LIBRARY_PATH and the sources ExercisePlot.h, ExercisePlot.cc to the $DEV_ROOT/examples/Makefile.
//#include <examples/ExercisePlot.h>
 

plotBermudanExercise();
	 
	



/*******************************************************************************
 *
 *             STOCHASTIC PROCESSES, PATH FUNCTIONALS
 *
*******************************************************************************/	


// How long does it take a d dimensional Brownian motion starting at zero to
// hit the surface of the unit ball? Patience, this is slow.
// include <examples/Examples.h>  
/*
         int dim=5,                // dimension
             T=500,                // maximum number of time steps allotted
             nPath=10000;          // number of paths averaged over 
	 Real dt=0.01;             // size of time step

	 Examples::brownianMotionInBall(dim,T,dt,nPath);
*/ 	
	

// Solving the Dirichlet problem on the ball using Brownian motion.    
// include <martingale/DirichletProblem.h>

// DirichletProblemExample::runExample();


	
/*********************************************************************************/
 
    
	return 0;

} // end main
