#ifndef TEMPDEF
#define TEMPDEF

using namespace std;

#include <iostream>
#include <iomanip>
#include <string>
#include <sstream>
#include <cstdio>
#include <typeinfo>
#include <cxxabi.h>
//#include <strstream>
#include <iomanip>
#include <fstream>
#include <ctype.h>
#include <map>
#include <vector>

#define TO_STRING(T) \
  inline string   to_string( const T& t ) { return t.as_string(); } \
  inline ostream& operator << (ostream& out, const T& t) { return out << t.as_string(); } \
  inline string   operator + (const char * in, const T& t) { return string(in) + to_string(t); } \
  inline string   operator + (const string& in, const T& t) { return in + to_string(t); } \
  inline string&  operator += (string& in, const T& t) { return in += to_string(t); }

#define TO_STRING_APPEND(T) \
  inline string operator + (const string& t, const T& u) { return t + to_string(u); }

#define TO_STRING_APPEND_T1(A) \
  template<typename T> \
  inline string operator + (const string& t, const A& u) { return t + to_string(u); }

#define TO_STRING_APPEND_T2(A,B) \
  template<typename T, typename U> \
  inline string operator + (const string& t, const A,B& u) { return t + to_string(u); }

#define TO_STRING_STREAM(T) \
  TO_STRING_APPEND(A) \
  inline ostream& operator << (ostream& out, const A& u) { return out << to_string(u); }

#define TO_STRING_STREAM_T1(A) \
  TO_STRING_APPEND_T1(A) \
  template<typename T> \
  inline ostream& operator << (ostream& out, const A& u) { return out << to_string(u); }

#define TO_STRING_STREAM_T2(A,B) \
  TO_STRING_APPEND_T2(A,B) \
  template<typename T, typename U> \
  inline ostream& operator << (ostream& out, const A,B& u) { return out << to_string(u); }

template<class T>
inline string to_string(const T* t) {
  char buf[64];
  sprintf(buf, "&(%p)", t);
  return buf;
}


inline string to_string(const char* ch) {
  return string(ch);
}


inline string to_string(const string& s) {
  return s;
}


inline string to_string(const void* t) {
  char buf[64];
  sprintf(buf, "&%p", t);
  return buf;
}


TO_STRING_APPEND(void*);

inline string to_string(const bool& i) {
  static string t = "true";
  static string f = "false";
  return i ? t : f;
}


TO_STRING_APPEND(bool);

template<typename T, typename U>
inline string to_string(const map<T,U>& m) {
  string out = "{";

  for (typename map<T, U>::const_iterator i = m.begin(); i != m.end(); ++i) {
    if (i != m.begin()) out.append("; ");
    out.append(to_string(i->first)).append("->").append(to_string(i->second));
  }

  out.append("}");
  return out;
}


TO_STRING_STREAM_T2(map<T,U>);

template<typename T>
inline string to_string(const vector<T>& m) {
  string out = "{";

  for (unsigned int i = 0; i < m.size(); ++i) {
    if (i != 0) out.append("; ");
    out.append(to_string(m[i]));
  }

  out.append("}");
  return out;
}


TO_STRING_STREAM_T2(vector<T,U>);

string to_string(const type_info& i);

#define SCALAR_TO_STRING(T) \
  inline string to_string(const T& t) { ostringstream o; o << t; return o.str(); } \
  TO_STRING_APPEND(T)

SCALAR_TO_STRING(char);
SCALAR_TO_STRING(unsigned char);
SCALAR_TO_STRING(short);
SCALAR_TO_STRING(unsigned short);
SCALAR_TO_STRING(int);
SCALAR_TO_STRING(unsigned int);
SCALAR_TO_STRING(long);
SCALAR_TO_STRING(unsigned long);
SCALAR_TO_STRING(long long);
SCALAR_TO_STRING(unsigned long long);

inline string to_string(const float& t) {
  ostringstream o;
  o << setprecision(99) << t;
  return o.str();
}


TO_STRING_APPEND(float);

inline string to_string(const double& t) {
  ostringstream o;
  o << setprecision(99) << t;
  return o.str();
}


TO_STRING_APPEND(double);

string to_human_readable(const void *data, int length);
inline string to_human_readable(const string& s) {
  return to_human_readable(s.data(), s.length());
}


string to_hex_string(const void *data, int length);
inline string to_hex_string(const string& s) {
  return to_hex_string(s.data(), s.length());
}


template <typename Int>
inline string to_hex_string(Int l) {
  bool written = false;
  string out = "0x";

  for (int shift = (sizeof(Int) - 1) * 8; shift >= 0; shift -= 8) {
    unsigned char ch = (unsigned char)(l >> shift);
    if (ch) written = true;
    if (written) {
      out += "0123456789ABCDEF"[ch >> 4];
      out += "0123456789ABCDEF"[ch & 0xF];
    }
  }

  if (!written) out += "0";
  return out;
}


string to_escaped_string(const void *data, int length);
inline string to_escaped_string(const string& s) {
  return to_escaped_string(s.data(), s.length());
}
#endif
